// Tables for policy rules with uncertainty and asymmetry variables

clear

// pick the folder for data:
cd "D:\Projects\Brookings 2015\Taylor Rules\Data"
//cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission"

use quarterlyData, clear

// pick the directory for output
cd "C:\swp55\Docs\Brookings 2015\Tables"
//cd "C:\Users\g1tjs01\Documents\brookings\1987 extension\files for final submission\output"

// make time series 
tsset time
drop if time<tq(1987q3)
drop if time>tq(2008q4)

// pick vix
rename old_vix vix // use this since go back to 1987

// define variables for taylor rule estimation
gen corecpi_4q = (corecpi_T0 + corecpi_T1 + corecpi_T2 + corecpi_T3 )/4
gen outputgap_4q = (outputgap_T0 + outputgap_T1 + outputgap_T2 + outputgap_T3)/4
gen ffr = ffr_thirty_days_forward 


// Define uncertainty and disagreement variables
// Uncertainty variables are based on constant horizon forecasts dervied from weighting quarterly binned forecasts of current and following year
// Disagreement variables based on direct constant horizon point forecasts

// Uncertainty as we do it. Baseline is median
gen UncInf = med_of_chinf_bin_stdev
gen UncGDP = med_of_chgdp_bin_stdev

// Disagreement variables. Baseline is iqr
gen DisagInfl = iqr_pf_inflation_ch
gen DisagGDP = iqr_pf_gdp_ch

// central tendency across forecasters of mean less mode (From the bins, using weighted bins) 
gen meanlessmodeInfl = median_mlmo_chinf_bin
gen meanlessmodeGDP  = median_mlmo_chgdp_bin

// Mean minus mode (across forecasters) of constant horizon point forecasts 
gen meanlessmodeInflPF = - mode_pf_inflation_ch + mean_pf_inflation_ch
gen meanlessmodeGDPPF = - mode_pf_gdp_ch + mean_pf_gdp_ch

// Summary Statistics using variable names in paper
gen vInf = UncInf
gen vGDP = UncGDP
gen DvInf = DisagInfl
gen DvGDP = DisagGDP
gen sInf = meanlessmodeInfl
gen sGDP = meanlessmodeGDP
gen DsInf = meanlessmodeInflPF
gen DsGDP = meanlessmodeGDPPF
gen VXO = vix
gen Spread = credit_spread
gen JLN = h12_macro_uncert
gen fcGap = outputgap_4q
gen fcInf = corecpi_4q

// Label variables (note that some variables are renamed duplicates)
label var time "quarter"
label var corecpi_4q "Four-quarter average of core CPI"
label var outputgap_4q "Four-quarter average of output gap"
label var ffr "Thirty day forward average of Fed Funds Rate target after FOMC meetings"
label var vInf "Median across forecasters of the standard deviation of probability-based inflation forecasts"
label var vGDP "Median across forecasters of the standard deviation of probability-based GDP forecasts"
label var DvInf "Interquartile range of inflation point forecasts"
label var DvGDP "Interquartile range of GDP point forecasts"
label var sInf "Median across forecasters of mean-less-mode probability-based inflation forecasts"
label var sGDP "Median across forecasters of the standard deviation of probability-based GDP forecasts"
label var DsInf "Mean minus mode inflation point forecasts"
label var DsGDP "Mean minus mode GDP point forecasts"
label var VXO "Market volatility"
label var Spread "Moody's Baa corporate yield minues 10-year treasury yield"
label var JLN "Quarterly average of 12-month ahead macroeconomic uncertainty"
label var fcGap "four-quarter average of output gap"
label var fcInf "four-quarter average of core CPI"
label var UncInf "Median across forecasters of the standard deviation of probability-based inflation forecasts"
label var UncGDP "Median across forecasters of the standard deviation of probability-based GDP forecasts"
label var DisagInfl "Interquartile range of inflation point forecasts"
label var DisagGDP "Interquartile range of GDP point forecasts"
label var meanlessmodeInfl "Median across forecasters of mean-less-mode probability-based inflation forecasts"
label var meanlessmodeGDP "Median across forecasters of the standard deviation of probability-based GDP forecasts"
label var meanlessmodeInflPF "Mean minus mode inflation point forecasts"
label var meanlessmodeGDPPF "Mean minus mode GDP point forecasts"


// Summary statistics: Input for Tables 5 and 7
// These tables will go to current directory
sutex fcInf fcGap VXO JLN vInf vGDP DvInf DvGDP Spread sInf sGDP DsInf DsGDP , dig(2) minmax file("sum_stats_quarterly") replace
corrtex fcInf fcGap VXO JLN vInf vGDP DvInf DvGDP Spread sInf sGDP DsInf DsGDP , dig(2) file("corr_stats_quarterly") replace

